/*
 * Decompiled with CFR 0.152.
 */
package com.qumeng.advlib.gm;

import android.content.Context;
import android.view.ViewGroup;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.mediation.MediationConstant;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.splash.MediationCustomSplashLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomServiceConfig;
import com.qumeng.advlib.api.AiClkAdManager;
import com.qumeng.advlib.core.AdRequestParam;
import com.qumeng.advlib.core.IMultiAdObject;
import com.qumeng.advlib.core.IMultiAdRequest;
import com.qumeng.advlib.gm.ThreadUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class QMSplashAdapter
extends MediationCustomSplashLoader {
    private static final String TAG = "GM_qumeng_splash";
    private volatile IMultiAdObject mSplashAD;

    public void load(Context context, AdSlot adSlot, final MediationCustomServiceConfig mediationCustomServiceConfig) {
        ThreadUtils.runOnThreadPool(new Runnable(){

            @Override
            public void run() {
                AdRequestParam requestParam = new AdRequestParam.Builder().adslotID(mediationCustomServiceConfig.getADNNetworkSlotId()).adType(6).adLoadListener(new AdRequestParam.ADLoadListener(){

                    public void onADLoaded(IMultiAdObject object) {
                        if (object != null) {
                            QMSplashAdapter.this.mSplashAD = object;
                            if (QMSplashAdapter.this.isBidding()) {
                                double ecpm = QMSplashAdapter.this.mSplashAD.getECPM();
                                if (ecpm < 0.0) {
                                    ecpm = 0.0;
                                }
                                QMSplashAdapter.this.callLoadSuccess(ecpm);
                            } else {
                                QMSplashAdapter.this.callLoadSuccess();
                            }
                        }
                    }

                    public void onAdFailed(String adError) {
                        if (adError != null) {
                            QMSplashAdapter.this.callLoadFail(40000, adError);
                        } else {
                            QMSplashAdapter.this.callLoadFail(40000, "no ad");
                        }
                    }
                }).build();
                IMultiAdRequest multiAdRequest = AiClkAdManager.getInstance().createAdRequest();
                if (multiAdRequest != null) {
                    multiAdRequest.invokeADV(requestParam);
                }
            }
        });
    }

    public void showAd(final ViewGroup container) {
        ThreadUtils.runOnUIThreadByThreadPool(new Runnable(){

            @Override
            public void run() {
                if (QMSplashAdapter.this.mSplashAD != null && container != null) {
                    container.removeAllViews();
                    QMSplashAdapter.this.mSplashAD.showSplashView(container, new IMultiAdObject.SplashEventListener(){

                        public void onObClicked() {
                            QMSplashAdapter.this.callSplashAdClicked();
                        }

                        public void onObShow() {
                            QMSplashAdapter.this.callSplashAdShow();
                        }

                        public void onObSkip() {
                            QMSplashAdapter.this.callSplashAdSkip();
                        }

                        public void onObTimeOver() {
                            QMSplashAdapter.this.callSplashAdSkip();
                        }
                    });
                }
            }
        });
    }

    public MediationConstant.AdIsReadyStatus isReadyCondition() {
        Future<MediationConstant.AdIsReadyStatus> future = ThreadUtils.runOnThreadPool(new Callable<MediationConstant.AdIsReadyStatus>(){

            @Override
            public MediationConstant.AdIsReadyStatus call() throws Exception {
                if (QMSplashAdapter.this.mSplashAD != null) {
                    return MediationConstant.AdIsReadyStatus.AD_IS_READY;
                }
                return MediationConstant.AdIsReadyStatus.AD_IS_NOT_READY;
            }
        });
        try {
            MediationConstant.AdIsReadyStatus result = future.get(500L, TimeUnit.MILLISECONDS);
            if (result != null) {
                return result;
            }
            return MediationConstant.AdIsReadyStatus.AD_IS_NOT_READY;
        }
        catch (Exception e) {
            e.printStackTrace();
            return MediationConstant.AdIsReadyStatus.AD_IS_NOT_READY;
        }
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mSplashAD = null;
    }

    public boolean isBidding() {
        return this.getBiddingType() == 1;
    }
}

