/*
 * Decompiled with CFR 0.152.
 */
package com.qumeng.advlib.gm;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.banner.MediationCustomBannerLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomServiceConfig;
import com.qumeng.advlib.api.AiClkAdManager;
import com.qumeng.advlib.core.AdRequestParam;
import com.qumeng.advlib.core.IMultiAdObject;
import com.qumeng.advlib.core.IMultiAdRequest;
import com.qumeng.advlib.gm.ThreadUtils;

public class QMBannerAdapter
extends MediationCustomBannerLoader {
    private LinearLayout mBannerView;
    private IMultiAdObject adModel;

    public View getAdView() {
        if (this.adModel != null) {
            this.adModel.bindView((ViewGroup)this.mBannerView, new IMultiAdObject.ADEventListener(){

                public void onAdClick() {
                    QMBannerAdapter.this.callBannerAdClick();
                }

                public void onADExposed() {
                    QMBannerAdapter.this.callBannerAdShow();
                }

                public void onAdFailed(String errorMsg) {
                }
            });
            return this.mBannerView;
        }
        return null;
    }

    public void load(final Context context, AdSlot adSlot, final MediationCustomServiceConfig mediationCustomServiceConfig) {
        ThreadUtils.runOnThreadPool(new Runnable(){

            @Override
            public void run() {
                AdRequestParam requestParam = new AdRequestParam.Builder().adslotID(mediationCustomServiceConfig.getADNNetworkSlotId()).adType(3).adLoadListener(new AdRequestParam.ADLoadListener(){

                    public void onADLoaded(IMultiAdObject adModel) {
                        adModel.setADStateListener(new IMultiAdObject.ADStateListener(){

                            public void onAdEvent(int eventType, @NonNull Bundle data) {
                                if (eventType == 2) {
                                    QMBannerAdapter.this.callBannerAdClosed();
                                }
                            }
                        });
                        QMBannerAdapter.this.mBannerView = new LinearLayout(context);
                        QMBannerAdapter.this.adModel = adModel;
                        if (QMBannerAdapter.this.isBidding()) {
                            double ecpm = adModel.getECPM();
                            if (ecpm < 0.0) {
                                ecpm = 0.0;
                            }
                            QMBannerAdapter.this.callLoadSuccess(ecpm);
                        } else {
                            QMBannerAdapter.this.callLoadSuccess();
                        }
                    }

                    public void onAdFailed(String errorMsg) {
                        QMBannerAdapter.this.callLoadFail(9999, errorMsg);
                    }
                }).build();
                IMultiAdRequest multiAdRequest = AiClkAdManager.getInstance().createAdRequest();
                if (multiAdRequest != null) {
                    multiAdRequest.invokeADV(requestParam);
                }
            }
        });
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public boolean isBidding() {
        return this.getBiddingType() == 1;
    }
}

