/*
 * Decompiled with CFR 0.152.
 */
package com.qumeng.advlib.gm;

import android.content.Context;
import android.view.ViewGroup;
import com.bytedance.msdk.api.v2.GMAdConstant;
import com.bytedance.msdk.api.v2.ad.custom.GMCustomAdError;
import com.bytedance.msdk.api.v2.ad.custom.bean.GMCustomServiceConfig;
import com.bytedance.msdk.api.v2.ad.custom.splash.GMCustomSplashAdapter;
import com.bytedance.msdk.api.v2.slot.GMAdSlotSplash;
import com.qumeng.advlib.api.AiClkAdManager;
import com.qumeng.advlib.core.AdRequestParam;
import com.qumeng.advlib.core.IMultiAdObject;
import com.qumeng.advlib.core.IMultiAdRequest;
import com.qumeng.advlib.gm.ThreadUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class QMSplashAdapter
extends GMCustomSplashAdapter {
    private static final String TAG = "GM_qumeng_splash";
    private volatile IMultiAdObject mSplashAD;

    public void load(Context context, GMAdSlotSplash adSlot, final GMCustomServiceConfig serviceConfig) {
        ThreadUtils.runOnThreadPool(new Runnable(){

            @Override
            public void run() {
                AdRequestParam requestParam = new AdRequestParam.Builder().adslotID(serviceConfig.getADNNetworkSlotId()).adType(6).adLoadListener(new AdRequestParam.ADLoadListener(){

                    public void onADLoaded(IMultiAdObject object) {
                        if (object != null) {
                            QMSplashAdapter.this.mSplashAD = object;
                            if (QMSplashAdapter.this.isBidding()) {
                                double ecpm = QMSplashAdapter.this.mSplashAD.getECPM();
                                if (ecpm < 0.0) {
                                    ecpm = 0.0;
                                }
                                QMSplashAdapter.this.callLoadSuccess(ecpm);
                            } else {
                                QMSplashAdapter.this.callLoadSuccess();
                            }
                        }
                    }

                    public void onAdFailed(String adError) {
                        if (adError != null) {
                            QMSplashAdapter.this.callLoadFail(new GMCustomAdError(40000, adError));
                        } else {
                            QMSplashAdapter.this.callLoadFail(new GMCustomAdError(40000, "no ad"));
                        }
                    }
                }).build();
                IMultiAdRequest multiAdRequest = AiClkAdManager.getInstance().createAdRequest();
                if (multiAdRequest != null) {
                    multiAdRequest.invokeADV(requestParam);
                }
            }
        });
    }

    public void showAd(final ViewGroup container) {
        ThreadUtils.runOnUIThreadByThreadPool(new Runnable(){

            @Override
            public void run() {
                if (QMSplashAdapter.this.mSplashAD != null && container != null) {
                    container.removeAllViews();
                    QMSplashAdapter.this.mSplashAD.showSplashView(container, new IMultiAdObject.SplashEventListener(){

                        public void onObClicked() {
                            QMSplashAdapter.this.callSplashAdClicked();
                        }

                        public void onObShow() {
                            QMSplashAdapter.this.callSplashAdShow();
                        }

                        public void onObSkip() {
                            QMSplashAdapter.this.callSplashAdSkip();
                        }

                        public void onObTimeOver() {
                            QMSplashAdapter.this.callSplashAdSkip();
                        }
                    });
                }
            }
        });
    }

    public GMAdConstant.AdIsReadyStatus isReadyStatus() {
        Future<GMAdConstant.AdIsReadyStatus> future = ThreadUtils.runOnThreadPool(new Callable<GMAdConstant.AdIsReadyStatus>(){

            @Override
            public GMAdConstant.AdIsReadyStatus call() {
                if (QMSplashAdapter.this.mSplashAD != null) {
                    return GMAdConstant.AdIsReadyStatus.AD_IS_READY;
                }
                return GMAdConstant.AdIsReadyStatus.AD_IS_NOT_READY;
            }
        });
        try {
            GMAdConstant.AdIsReadyStatus result = future.get(500L, TimeUnit.MILLISECONDS);
            if (result != null) {
                return result;
            }
            return GMAdConstant.AdIsReadyStatus.AD_IS_NOT_READY;
        }
        catch (Exception e) {
            e.printStackTrace();
            return GMAdConstant.AdIsReadyStatus.AD_IS_NOT_READY;
        }
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mSplashAD = null;
    }

    public boolean isBidding() {
        return this.getBiddingType() == 1;
    }
}

