/*
 * Decompiled with CFR 0.152.
 */
package com.qumeng.advlib.gm;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.bytedance.msdk.api.reward.RewardItem;
import com.bytedance.msdk.api.v2.GMAdConstant;
import com.bytedance.msdk.api.v2.ad.custom.GMCustomAdError;
import com.bytedance.msdk.api.v2.ad.custom.bean.GMCustomServiceConfig;
import com.bytedance.msdk.api.v2.ad.custom.reward.GMCustomRewardAdapter;
import com.bytedance.msdk.api.v2.slot.GMAdSlotRewardVideo;
import com.qumeng.advlib.api.AiClkAdManager;
import com.qumeng.advlib.core.AdRequestParam;
import com.qumeng.advlib.core.IMultiAdObject;
import com.qumeng.advlib.core.IMultiAdRequest;
import com.qumeng.advlib.gm.ThreadUtils;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class QMRewardVideoAdapter
extends GMCustomRewardAdapter {
    private static final String TAG = "GMAdLoadManager_QMCustomerRewardAdapter";
    private volatile IMultiAdObject mRewardVideoAD;
    private GMAdSlotRewardVideo adSlot;

    public void load(Context context, GMAdSlotRewardVideo adSlot, final GMCustomServiceConfig serviceConfig) {
        this.adSlot = adSlot;
        ThreadUtils.runOnThreadPool(new Runnable(){

            @Override
            public void run() {
                AdRequestParam requestParam = new AdRequestParam.Builder().adslotID(serviceConfig.getADNNetworkSlotId()).adType(4).adLoadListener(new AdRequestParam.ADLoadListener(){

                    public void onADLoaded(IMultiAdObject object) {
                        if (object != null) {
                            QMRewardVideoAdapter.this.mRewardVideoAD = object;
                            if (QMRewardVideoAdapter.this.isBidding()) {
                                double ecpm = QMRewardVideoAdapter.this.mRewardVideoAD.getECPM();
                                if (ecpm < 0.0) {
                                    ecpm = 0.0;
                                }
                                QMRewardVideoAdapter.this.callLoadSuccess(ecpm);
                            } else {
                                QMRewardVideoAdapter.this.callLoadSuccess();
                            }
                        }
                    }

                    public void onAdFailed(String adError) {
                        if (adError != null) {
                            QMRewardVideoAdapter.this.callLoadFail(new GMCustomAdError(40000, adError));
                        } else {
                            QMRewardVideoAdapter.this.callLoadFail(new GMCustomAdError(40000, "no ad"));
                        }
                    }
                }).build();
                IMultiAdRequest multiAdRequest = AiClkAdManager.getInstance().createAdRequest();
                if (multiAdRequest != null) {
                    multiAdRequest.invokeADV(requestParam);
                }
            }
        });
    }

    public void showAd(Activity activity) {
        if (this.mRewardVideoAD != null) {
            this.mRewardVideoAD.showRewardVideo(activity, new AdRequestParam.ADRewardVideoListener(){

                public void onAdShow(Bundle bundle) {
                    QMRewardVideoAdapter.this.callRewardedAdShow();
                }

                public void onAdClick(Bundle bundle) {
                    QMRewardVideoAdapter.this.callRewardClick();
                }

                public void onAdClose(Bundle bundle) {
                    QMRewardVideoAdapter.this.callRewardedAdClosed();
                }

                public void onVideoComplete(Bundle bundle) {
                    QMRewardVideoAdapter.this.callRewardVideoComplete();
                }

                public void onVideoError(Bundle bundle) {
                    QMRewardVideoAdapter.this.callRewardVideoError();
                }

                public void onReward(Bundle bundle) {
                    QMRewardVideoAdapter.this.callRewardVerify(new RewardItem(){

                        public boolean rewardVerify() {
                            return true;
                        }

                        public float getAmount() {
                            if (QMRewardVideoAdapter.this.adSlot != null) {
                                return QMRewardVideoAdapter.this.adSlot.getRewardAmount();
                            }
                            return 0.0f;
                        }

                        public String getRewardName() {
                            if (QMRewardVideoAdapter.this.adSlot != null) {
                                return QMRewardVideoAdapter.this.adSlot.getRewardName();
                            }
                            return "";
                        }

                        public Map<String, Object> getCustomData() {
                            return null;
                        }
                    });
                }

                public void onSkippedVideo(Bundle bundle) {
                    QMRewardVideoAdapter.this.callRewardSkippedVideo();
                }
            });
        }
    }

    public GMAdConstant.AdIsReadyStatus isReadyStatus() {
        Future<GMAdConstant.AdIsReadyStatus> future = ThreadUtils.runOnThreadPool(new Callable<GMAdConstant.AdIsReadyStatus>(){

            @Override
            public GMAdConstant.AdIsReadyStatus call() {
                if (QMRewardVideoAdapter.this.mRewardVideoAD != null) {
                    return GMAdConstant.AdIsReadyStatus.AD_IS_READY;
                }
                return GMAdConstant.AdIsReadyStatus.AD_IS_NOT_READY;
            }
        });
        try {
            GMAdConstant.AdIsReadyStatus result = future.get(500L, TimeUnit.MILLISECONDS);
            if (result != null) {
                return result;
            }
            return GMAdConstant.AdIsReadyStatus.AD_IS_NOT_READY;
        }
        catch (Exception e) {
            e.printStackTrace();
            return GMAdConstant.AdIsReadyStatus.AD_IS_NOT_READY;
        }
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mRewardVideoAD = null;
    }

    public boolean isBidding() {
        return this.getBiddingType() == 1;
    }

    public void receiveBidResult(boolean win, double winnerPrice, int loseReason, Map<String, Object> extra) {
        super.receiveBidResult(win, winnerPrice, loseReason, extra);
    }
}

