/*
 * Decompiled with CFR 0.152.
 */
package com.qumeng.advlib.gm;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.bytedance.msdk.api.v2.ad.custom.GMCustomAdError;
import com.bytedance.msdk.api.v2.ad.custom.bean.GMCustomServiceConfig;
import com.bytedance.msdk.api.v2.ad.custom.interstitial.GMCustomInterstitialAdapter;
import com.bytedance.msdk.api.v2.slot.GMAdSlotInterstitial;
import com.qumeng.advlib.api.AiClkAdManager;
import com.qumeng.advlib.core.AdRequestParam;
import com.qumeng.advlib.core.IMultiAdObject;
import com.qumeng.advlib.core.IMultiAdRequest;
import com.qumeng.advlib.gm.ThreadUtils;

public class QMInterstitialAdapter
extends GMCustomInterstitialAdapter {
    private volatile IMultiAdObject mRewardVideoAD;

    public void load(Context context, GMAdSlotInterstitial gmAdSlotInterstitial, final GMCustomServiceConfig gmCustomServiceConfig) {
        ThreadUtils.runOnThreadPool(new Runnable(){

            @Override
            public void run() {
                AdRequestParam requestParam = new AdRequestParam.Builder().adslotID(gmCustomServiceConfig.getADNNetworkSlotId()).adType(2).adLoadListener(new AdRequestParam.ADLoadListener(){

                    public void onADLoaded(IMultiAdObject object) {
                        if (object != null) {
                            QMInterstitialAdapter.this.mRewardVideoAD = object;
                            if (QMInterstitialAdapter.this.isBidding()) {
                                double ecpm = QMInterstitialAdapter.this.mRewardVideoAD.getECPM();
                                if (ecpm < 0.0) {
                                    ecpm = 0.0;
                                }
                                QMInterstitialAdapter.this.callLoadSuccess(ecpm);
                            } else {
                                QMInterstitialAdapter.this.callLoadSuccess();
                            }
                        }
                    }

                    public void onAdFailed(String adError) {
                        if (adError != null) {
                            QMInterstitialAdapter.this.callLoadFail(new GMCustomAdError(40000, adError));
                        } else {
                            QMInterstitialAdapter.this.callLoadFail(new GMCustomAdError(40000, "no ad"));
                        }
                    }
                }).build();
                IMultiAdRequest multiAdRequest = AiClkAdManager.getInstance().createAdRequest();
                if (multiAdRequest != null) {
                    multiAdRequest.invokeADV(requestParam);
                }
            }
        });
    }

    public void showAd(final Activity activity) {
        ThreadUtils.runOnUIThreadByThreadPool(new Runnable(){

            @Override
            public void run() {
                if (QMInterstitialAdapter.this.mRewardVideoAD != null) {
                    QMInterstitialAdapter.this.mRewardVideoAD.showInteractionAd(activity, new AdRequestParam.ADInteractionListener(){

                        public void onAdClose(Bundle data) {
                            QMInterstitialAdapter.this.callInterstitialClosed();
                        }

                        public void onAdClick() {
                            QMInterstitialAdapter.this.callInterstitialAdClick();
                        }

                        public void onADExposed() {
                            QMInterstitialAdapter.this.callInterstitialShow();
                        }

                        public void onAdFailed(String errorMsg) {
                        }
                    });
                }
            }
        });
    }

    public boolean isBidding() {
        return this.getBiddingType() == 1;
    }
}

