/*
 * Decompiled with CFR 0.152.
 */
package com.qumeng.advlib.gm;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.bytedance.msdk.api.v2.ad.custom.GMCustomAdError;
import com.bytedance.msdk.api.v2.ad.custom.banner.GMCustomBannerAdapter;
import com.bytedance.msdk.api.v2.ad.custom.bean.GMCustomServiceConfig;
import com.bytedance.msdk.api.v2.slot.GMAdSlotBanner;
import com.qumeng.advlib.api.AiClkAdManager;
import com.qumeng.advlib.core.AdRequestParam;
import com.qumeng.advlib.core.IMultiAdObject;
import com.qumeng.advlib.core.IMultiAdRequest;
import com.qumeng.advlib.gm.ThreadUtils;

public class QMBannerAdapter
extends GMCustomBannerAdapter {
    private GMAdSlotBanner mAdSlot;
    private Context mContext;
    private LinearLayout mBannerView;
    private IMultiAdObject adModel;

    public View getAdView() {
        if (this.adModel != null) {
            this.adModel.bindView((ViewGroup)this.mBannerView, new IMultiAdObject.ADEventListener(){

                public void onAdClick() {
                    QMBannerAdapter.this.callBannerAdClicked();
                }

                public void onADExposed() {
                    QMBannerAdapter.this.callBannerAdShow();
                }

                public void onAdFailed(String errorMsg) {
                }
            });
            return this.mBannerView;
        }
        return null;
    }

    public void load(final Context context, final GMAdSlotBanner gmAdSlotBanner, final GMCustomServiceConfig gmCustomServiceConfig) {
        ThreadUtils.runOnThreadPool(new Runnable(){

            @Override
            public void run() {
                QMBannerAdapter.this.mContext = context;
                QMBannerAdapter.this.mAdSlot = gmAdSlotBanner;
                AdRequestParam requestParam = new AdRequestParam.Builder().adslotID(gmCustomServiceConfig.getADNNetworkSlotId()).adType(3).adLoadListener(new AdRequestParam.ADLoadListener(){

                    public void onADLoaded(IMultiAdObject adModel) {
                        QMBannerAdapter.this.mBannerView = new LinearLayout(context);
                        QMBannerAdapter.this.adModel = adModel;
                        if (QMBannerAdapter.this.isBidding()) {
                            double ecpm = adModel.getECPM();
                            if (ecpm < 0.0) {
                                ecpm = 0.0;
                            }
                            QMBannerAdapter.this.callLoadSuccess(ecpm);
                        } else {
                            QMBannerAdapter.this.callLoadSuccess();
                        }
                    }

                    public void onAdFailed(String errorMsg) {
                        QMBannerAdapter.this.callLoadFail(new GMCustomAdError(9999, errorMsg));
                    }
                }).build();
                IMultiAdRequest multiAdRequest = AiClkAdManager.getInstance().createAdRequest();
                if (multiAdRequest != null) {
                    multiAdRequest.invokeADV(requestParam);
                }
            }
        });
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public boolean isBidding() {
        return this.getBiddingType() == 1;
    }
}

